clc
clear

subplot(1,3,1)
load("data_300.mat");
E1 = squeeze(Err(20,:,1:15))

x = [0:14].*2*log(20);
options.x_axis = x;
options.marker = "-^"

options.color_line = [179, 63, 64]./255 ;
options.color_area = options.color_line + (1-options.color_line)*2.3/4 ;
plot_areaerrorbar(E1,options)
grid on

hold on
E1 = squeeze(Err(14,:,1:15))

x = [0:14].*2*log(14);
options.x_axis = x;
options.marker = "-o"
options.color_line = [72, 161, 77]./255 ;
options.color_area = options.color_line + (1-options.color_line)*2.3/4 ;
plot_areaerrorbar(E1,options)
grid on

hold on 
E1 = squeeze(Err(5,:,1:15))

x = [0:14].*2*log(8);
options.x_axis = x;
options.marker = "-square"
options.color_line = [01, 119, 179]./255 ;
options.color_area = options.color_line + (1-options.color_line)*2.3/4 ;
plot_areaerrorbar(E1,options)
grid on
ylabel("Structural Hamming Distance (SHD)")
xlim([0 60])


xlabel("Number of random interventions")
legend("No. of Treatments = 20" , "No. of Treatments = 15", "No. of Treatments = 5")
legend("","No. of Treatments = 20","","No. of Treatments = 15","","No. of Treatments = 5","Interpreter","latex")
title("dmax = O(n)")
subplot(1,3,2)
load("data_300_lgn.mat");
E1 = squeeze(Err(20,:,1:15))

x = [0:14].*2*log(20);
options.x_axis = x;
options.marker = "-^"

options.color_line = [179, 63, 64]./255 ;
options.color_area = options.color_line + (1-options.color_line)*2.3/4 ;
plot_areaerrorbar(E1,options)
grid on

hold on
E1 = squeeze(Err(14,:,1:15))

x = [0:14].*2*log(14);
options.x_axis = x;
options.marker = "-o"
options.color_line = [72, 161, 77]./255 ;
options.color_area = options.color_line + (1-options.color_line)*2.3/4 ;
plot_areaerrorbar(E1,options)
grid on

hold on 
E1 = squeeze(Err(5,:,1:15))

x = [0:14].*2*log(8);
options.x_axis = x;
options.marker = "-square"
options.color_line = [01, 119, 179]./255 ;
options.color_area = options.color_line + (1-options.color_line)*2.3/4 ;
plot_areaerrorbar(E1,options)
grid on
ylabel("Structural Hamming Distance (SHD)")
xlim([0 60])
ylim([0 30])

xlabel("Number of random interventions")
legend("No. of Treatments = 20" , "No. of Treatments = 15", "No. of Treatments = 5")

legend("","No. of Treatments = 20","","No. of Treatments = 15","","No. of Treatments = 5","Interpreter","latex")
title("dmax = O(log n)")
subplot(1,3,3)
load("data_300_cnst.mat");
E1 = squeeze(Err(20,:,1:15))

x = [0:14].*2*log(20);
options.x_axis = x;
options.marker = "-^"

options.color_line = [179, 63, 64]./255 ;
options.color_area = options.color_line + (1-options.color_line)*2.3/4 ;
plot_areaerrorbar(E1,options)
grid on

hold on
E1 = squeeze(Err(14,:,1:15))

x = [0:14].*2*log(14);
options.x_axis = x;
options.marker = "-o"
options.color_line = [72, 161, 77]./255 ;
options.color_area = options.color_line + (1-options.color_line)*2.3/4 ;
plot_areaerrorbar(E1,options)
grid on

hold on 
E1 = squeeze(Err(5,:,1:15))

x = [0:14].*2*log(8);
options.x_axis = x;
options.marker = "-square"
options.color_line = [01, 119, 179]./255 ;
options.color_area = options.color_line + (1-options.color_line)*2.3/4 ;
plot_areaerrorbar(E1,options)
grid on
ylabel("Structural Hamming Distance (SHD)")
xlim([0 60])


xlabel("Number of random interventions")

legend("No. of Treatments = 20" , "No. of Treatments = 15", "No. of Treatments = 5")
box on
title("dmax = O(1)")
legend("","No. of Treatments = 20","","No. of Treatments = 15","","No. of Treatments = 5","Interpreter","latex")
